﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Security.Cryptography;

namespace Kryptografia
{
    public class Hashowanie
    {
        public static string HashString(string str)
        {
            byte[] data = Encoding.UTF8.GetBytes(str);
            byte[] hash;

            using (SHA512 shaM = new SHA512Managed())
            {
                hash = shaM.ComputeHash(data);
            }

            string wynik = ByteArrayToString(hash);
            return wynik;
        }

        public static string ByteArrayToString(byte[] b)
        {
            StringBuilder hex = new StringBuilder(b.Length * 2);
            foreach (byte element in b)
            {
                hex.AppendFormat("{0:x2}", element);
            }
            return hex.ToString();
        }
        
        
        static void Main(string[] args)
        {

            string hasloJawnie = Console.ReadLine();

            Console.Write($"Hasło przed hashowaniem: {hasloJawnie}");
            Console.Write($"Hasło po hashowaniu: {HashString(hasloJawnie)}");
        

            string znaleziony = "brak";
            string hash = "13588a9cb59d457179a0b294857359a881d090870479ec48474336d64dc8cd6470bc7543fbf19beceb3d1bda81081134af152fe76ade1d1251abeca9d1949f7e";

            for(int i = 10000; i <= 99999; i++)
            {
                if(HashString(i.ToString()) == hash)
                {
                    znaleziony = i.ToString();
                    break;
                }
            }

            Console.WriteLine($"Znaleziony numer to: {znaleziony}");
            Console.ReadKey();
        }
    }
}
